/*
 * This source file was generated by the Gradle 'init' task
 */
package org.example;


import com.pusher.client.Pusher;
import com.pusher.client.channel.Channel;
import com.pusher.client.channel.SubscriptionEventListener;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.PusherOptions;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.connection.ConnectionStateChange;


public class App {
    public String getGreeting() {
        return "Hello World!";
    }

    public static void main(String[] args) {
        System.out.println(new App().getGreeting());
        String YOUR_APP_KEY="mqfzsnt3n1tetbgezmfb";
        String YOUR_APP_HOST="streamer.make-a-wish.at";

        // Create a new Pusher instance
		PusherOptions options = new PusherOptions();
		options.setHost(YOUR_APP_HOST);
		options.setActivityTimeout((long)10000L);

		
		Pusher pusher = new Pusher(YOUR_APP_KEY, options);

		pusher.connect(new ConnectionEventListener() {
		    @Override
		    public void onConnectionStateChange(ConnectionStateChange change) {
		        System.out.println("State changed to " + change.getCurrentState() +
		                           " from " + change.getPreviousState());
		    }

		    @Override
		    public void onError(String message, String code, Exception e) {
		        System.out.println("There was a problem connecting!");
		        System.out.println(message);
		        System.out.println(code);
		        System.out.println(e);
		    }
		}, ConnectionState.ALL);

		// Subscribe to a channel
		Channel channel = pusher.subscribe("donations");

		// Bind to listen for events called "my-event" sent to "my-channel"
		channel.bind("App\\Events\\DonationCompleted", new SubscriptionEventListener() {
		    @Override
		    public void onEvent(PusherEvent event) {
		        System.out.println("Received event with data: " + event.toString());
		    }
		});

		// Disconnect from the service
		pusher.disconnect();

		// Reconnect, with all channel subscriptions and event bindings automatically recreated
		pusher.connect();
		// The state change listener is notified when the connection has been re-established,
		// the subscription to "my-channel" and binding on "my-event" still exist.

		try 
		{
		    Thread.sleep(1000 * 60);
		} 
		catch(InterruptedException e)
		{
		     // this part is executed when an exception (in this example InterruptedException) occurs
		}
		//delay(5000);

        System.out.println("The end");

    }
}
